CREATE SCHEMA AgencjaArtystycznaPrzyklad;

SET search_path TO AgencjaArtystycznaPrzyklad;

CREATE TABLE Agenci (
	IDAgenta serial NOT NULL ,
	ImieAgenta varchar (25) NULL ,
	NazwiskoAgenta varchar (25) NULL ,
	AdresAgenta varchar (50) NULL ,
	MiastoAgenta varchar (30) NULL ,
	StanZamAgenta varchar (2) NULL ,
	KodPocztowyAgenta varchar (10) NULL ,
	TelefonAgenta varchar (15) NULL ,
	DataZatrudnienia date NULL ,
	Wynagrodzenie decimal(15,2) NULL DEFAULT 0 ,
	Premia float(24) NULL DEFAULT 0 
);

CREATE TABLE Klienci (
	IDKlienta serial NOT NULL ,
	ImieKlienta varchar (25) NULL ,
	NazwiskoKlienta varchar (25) NULL ,
	AdresKlienta varchar (50) NULL ,
	MiastoKlienta varchar (30) NULL ,
	StanZamKlienta varchar (2) NULL ,
	KodPocztowyKlienta varchar (10) NULL ,
	TelefonKlienta varchar (15) NULL 
);

CREATE TABLE Imprezy (
	NumerImprezy serial NOT NULL ,
	DzienRozpoczecia date NULL ,
	DzienZakonczenia date NULL ,
	GodzinaRozpoczecia time NULL ,
	GodzinaZakonczenia time NULL ,
	WartoscKontraktu decimal(15,2) NULL DEFAULT 0 ,
	IDKlienta int NULL DEFAULT 0 ,
	IDAgenta int NULL DEFAULT 0 ,
	IDWykonawcy int NULL DEFAULT 0
);

CREATE TABLE Czlonkowie_zespolu (
	IDWykonawcy int NOT NULL ,
	IDCzlonka int NOT NULL DEFAULT 0 ,
	Status smallint NULL DEFAULT 0
);

CREATE TABLE Style_wykonawcow (
	IDWykonawcy int NOT NULL ,
	IDStylu int NOT NULL  ,
	WplywStylu smallint NOT NULL
);

CREATE TABLE Wykonawcy (
	IDWykonawcy serial NOT NULL ,
	NazwaScenicznaWykonawcy varchar (50) NULL ,
	NrUbezpWykonawcy varchar (12) NULL ,
	AdresWykonawcy varchar (50) NULL ,
	MiastoWykonawcy varchar (30) NULL ,
	StanZamWykonawcy varchar (2) NULL ,
	KodPocztowyWykonawcy varchar (10) NULL ,
	TelefonWykonawcy varchar (15) NULL ,
	StronaInterWykonawcy varchar (50) NULL ,
	EmailWykonawcy varchar (50) NULL ,
	DataRejestracji date NULL  
);

CREATE TABLE Czlonkowie (
	IDCzlonka serial NOT NULL ,
	ImieCzlonka varchar (25) NULL ,
	NazwiskoCzlonka varchar (25) NULL ,
	TelefonCzlonka varchar (15) NULL ,
	Plec varchar (2) NULL 
);

CREATE TABLE Gusty_muzyczne (
	IDKlienta int NOT NULL ,
	IDStylu int NOT NULL ,
	KolejnoscPreferencji smallint NOT NULL DEFAULT 0
);

CREATE TABLE Style_muzyczne (
	IDStylu serial NOT NULL ,
	NazwaStylu varchar (75) NULL 
);

CREATE TABLE ztblDni (
        PoleDaty date NOT NULL 
);

CREATE TABLE ztblMiesiace ( 
        MiesiacRok varchar (20) NULL ,
        NumerRoku smallint NOT NULL ,
        NumerMiesiaca smallint NOT NULL ,
        PoczatekMiesiaca date NULL ,
        KoniecMiesiaca date NULL ,
        Styczen smallint NULL DEFAULT 0 ,
        Luty smallint NULL DEFAULT 0 ,
        Marzec smallint NULL DEFAULT 0 ,
        Kwiecien smallint NULL DEFAULT 0 ,
        Maj smallint NULL DEFAULT 0 ,
        Czerwiec smallint NULL DEFAULT 0 ,
        Lipiec smallint NULL DEFAULT 0 ,
        Sierpien smallint NULL DEFAULT 0 ,
        Wrzesien smallint NULL DEFAULT 0 ,
        Pazdziernik smallint NULL DEFAULT 0 ,
        Listopad smallint NULL DEFAULT 0 ,
        Grudzien smallint NULL DEFAULT 0
);

CREATE TABLE ztblPomijanieEtykiet (
        LicznikEtykiet int NOT NULL  
);

CREATE TABLE ztblTygodnie ( 
        PoczatekTygodnia date NOT NULL ,
        KoniecTygodnia date NULL 
);

 ALTER TABLE Agenci 
 ADD CONSTRAINT Agenci_PK PRIMARY KEY   
	(
		IDAgenta
	)  
;

CREATE INDEX Agenci_KodPocztowyAgenta ON Agenci(KodPocztowyAgenta);

ALTER TABLE Klienci 
ADD CONSTRAINT Klienci_PK PRIMARY KEY   
	(
		IDKlienta
	)  
;

CREATE INDEX Klienci_KodPocztowyKlienta ON Klienci(KodPocztowyKlienta);

ALTER TABLE Imprezy 
ADD CONSTRAINT Imprezy_PK PRIMARY KEY   
	(
		NumerImprezy
	)  
;

CREATE INDEX Imprezy_AgenciImprezy ON Imprezy(IDAgenta);

CREATE INDEX Imprezy_IDKlienta ON Imprezy(IDKlienta);

CREATE INDEX Imprezy_IDPracownika ON Imprezy(IDAgenta);

CREATE INDEX Imprezy_IDWykonawcy ON Imprezy(IDWykonawcy);

ALTER TABLE Czlonkowie_zespolu 
ADD CONSTRAINT Czlonkowie_zespolu_PK PRIMARY KEY   
	(
		IDWykonawcy,
		IDCzlonka
	)  
;

CREATE INDEX WykonawcyWykonawcaCzlonkowie ON Czlonkowie_zespolu(IDWykonawcy);

CREATE INDEX CzlonkowieWykonawcaCzlonkowie ON Czlonkowie_zespolu(IDCzlonka);

ALTER TABLE Style_wykonawcow 
ADD CONSTRAINT Style_wykonawcow_PK PRIMARY KEY   
	(
		IDWykonawcy,
		IDStylu
	)  
;

CREATE INDEX Style_wykonawcow_WykonawcyWykonawcaStyles ON Style_wykonawcow(IDWykonawcy);

CREATE INDEX Style_wykonawcow_StyleMuzyczneStyleWyk ON Style_wykonawcow(IDStylu);

ALTER TABLE Wykonawcy 
ADD CONSTRAINT Wykonawcy_PK PRIMARY KEY   
	(
		IDWykonawcy
	)  
;

CREATE UNIQUE INDEX Wykonawcy_IDWykonawcy ON Wykonawcy(IDWykonawcy);

CREATE INDEX KodPocztowyWykonawcy ON Wykonawcy(KodPocztowyWykonawcy);

ALTER TABLE Czlonkowie ADD 
	CONSTRAINT Czlonkowie_PK PRIMARY KEY   
	(
		IDCzlonka
	)  
;

CREATE INDEX IDCzlonka ON Czlonkowie(IDCzlonka);

ALTER TABLE Gusty_muzyczne 
ADD CONSTRAINT Gusty_muzyczne_PK PRIMARY KEY   
	(
		IDKlienta,
		IDStylu
	)  
;

CREATE INDEX Gusty_muzyczne_IDKlienta ON Gusty_muzyczne(IDKlienta);

CREATE INDEX Gusty_muzyczne_IDStylu ON Gusty_muzyczne(IDStylu);

ALTER TABLE Style_muzyczne 
ADD CONSTRAINT Style_muzyczne_PK PRIMARY KEY   
	(
		IDStylu
	)  
;

ALTER TABLE ztblDni 
ADD CONSTRAINT ztblDni_PK PRIMARY KEY 
        ( 
                PoleDaty 
        )
;

ALTER TABLE ztblMiesiace 
ADD CONSTRAINT ztblMiesiace_PK PRIMARY KEY 
        ( 
                NumerRoku, 
                NumerMiesiaca
        )
;

CREATE UNIQUE INDEX ztblMiesiace_KoniecMiesiaca ON ztblMiesiace(KoniecMiesiaca);

CREATE UNIQUE INDEX ztblMiesiace_PoczatekMiesiaca ON ztblMiesiace(PoczatekMiesiaca); 

CREATE UNIQUE INDEX ztblMiesiace_MiesiacRok ON ztblMiesiace(MiesiacRok);

ALTER TABLE ztblPomijanieEtykiet 
ADD CONSTRAINT ztblPomijanieEtykiet_PK PRIMARY KEY 
        (
                LicznikEtykiet 
        ) 
;

ALTER TABLE ztblTygodnie 
ADD CONSTRAINT ztblTygodnie_PK PRIMARY KEY 
        ( 
                PoczatekTygodnia 
        ) 
;

ALTER TABLE Imprezy 
ADD CONSTRAINT Imprezy_FK00 FOREIGN KEY 
	(
		IDAgenta
	) REFERENCES Agenci (
		IDAgenta
	),
ADD CONSTRAINT Imprezy_FK01 FOREIGN KEY 
	(
		IDKlienta
	) REFERENCES Klienci (
		IDKlienta
	),
ADD CONSTRAINT Imprezy_FK02 FOREIGN KEY 
	(
		IDWykonawcy
	) REFERENCES Wykonawcy (
		IDWykonawcy
	)
;

ALTER TABLE Czlonkowie_zespolu 
ADD CONSTRAINT Czlonkowie_zespolu_FK00 FOREIGN KEY 
	(
		IDWykonawcy
	) REFERENCES Wykonawcy (
		IDWykonawcy
	),
ADD CONSTRAINT Czlonkowie_zespolu_FK01 FOREIGN KEY 
	(
		IDCzlonka
	) REFERENCES Czlonkowie (
		IDCzlonka
	)
;

ALTER TABLE Style_wykonawcow 
ADD CONSTRAINT Style_wykonawcow_FK00 FOREIGN KEY 
	(
		IDWykonawcy
	) REFERENCES Wykonawcy (
		IDWykonawcy
	) ON DELETE CASCADE,
ADD CONSTRAINT Style_wykonawcow_FK01 FOREIGN KEY 
	(
		IDStylu
	) REFERENCES Style_muzyczne (
		IDStylu
	)
;

ALTER TABLE Gusty_muzyczne 
ADD CONSTRAINT Gusty_muzyczne_FK00 FOREIGN KEY 
	(
		IDKlienta
	) REFERENCES Klienci (
		IDKlienta
	) ON DELETE CASCADE,
ADD CONSTRAINT Gusty_muzyczne_FK01 FOREIGN KEY 
	(
		IDStylu
	) REFERENCES Style_muzyczne (
		IDStylu
	)
;

